import numpy as np
from src.pivot_utils import load_pivot_params, g_of_D

def test_pivot_constraints():
    a, b = load_pivot_params()
    assert abs(a*2.0 + b - 1.0) <= 1e-6   # g(2)=1
    assert a < 0.0                        # slope negative

def test_pivot_monotone_decreasing():
    a, b = load_pivot_params()
    Ds = np.linspace(1.0, 3.0, 21)
    gs = [g_of_D(D, a, b) for D in Ds]
    assert all(gs[i] >= gs[i+1] - 1e-12 for i in range(len(gs)-1))
